# Proyecto 2.2. Armamos 'El alien toca botón'

Esta actividad es muy parecida a la anterior, en cuanto a que hay un alien que tiene que tocar un botón.
Pero, a diferencia de la actividad anterior, ahora te toca a vos armar los procedimientos para mover al alien
y para tocar el botón. ¿Cómo? Pues, con bolitas.

Dado que el alien no existe previamente, tenemos que imaginarnos cómo es, y cómo decirle a Gobstones que queremos
un alien. Pero, como la base del lenguaje Gobstones son bolitas en el tablero, entonces, tenemos que usar bolitas 
para _"crear"_ un alien o cualquier otro elemento que querramos. 
A eso lo llamamos **representar** los elementos.

En este caso, la representación de los elementos te la damos ya definida, y vos tenés que completar los procedimientos
para que todo funcione. La representación es así:

| Elemento a representar     | Representación  | 
|:---------------------------|:----------------|
| El alien                   | 1 bolita verde  | 
| El botón sin tocar         | 2 bolitas rojas |
| El botón cuando fue tocado | 1 bolita roja   |

El tablero inicial de la actividad anterior, pero sin la vestimenta, es así:

<center>
![Tablero inicial](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAbgAAACwCAYAAAB97ntqAAAQYnpUWHRSYXcgcHJvZmlsZSB0eXBlIGV4aWYAAHjarZpXdhwxc4XfsQovAalQwHIQz/EOvHx/hR5SpEiF37JG4gw7IFS4oUdu/89/H/df/MkleZdFa2mleP7kllvsfKj++fO8B5/vz/tn1Nen8Pm4G697fORQ4j09v5b9vIfOcflxg+bX8fH5uNP5Gqe+BnqdeBsw2cyRD6/r6mugFJ/j4fW7a6/7ev6wnde/ue8QPrwG/fn3rARjCQdTdHEnjvMz2yyJFaSaOu+vn9GOFD4Lv/WUk34fO/f+8afgPeH/GjvfX1ekz6Fw/u2G8lOMXseDfB+7G6GPKwpvH+PnE+e83fk1dueses5+dtdzIVLFvTblX0OEZ5BFVeR0byu8lH/CZ72vxquyxUnGFtkcvKYLLUSifUIOK/Rwwr7vM0yWmOOOynuMM6Z7rCaNLc6blGyvcKKmlpYjOzFNspY4HN/XEu687c43Q2XmFbgyBgYL3PHl5b47+H95vQ90jpVuCBbMUm6sWFe0AmQZljn7yVUkJJxXTOXG976c/yk5r8QmMig3zJUNdj+eIYaEH7WVbp4T14nPzj+tEXS9BiBEzC0sJiQy4EtIEkrwGqOGQBwr+emsPKYcBxkIInEFd8hNSoXk0A3MzT0a7rVR4nMYaCERQqMoqWmpk6ychfrRXKmhLkmyE5EiKlWa9JJKLlJK0WIY1TVpVtGiqlWb9ppqrlJL1Vprq73FloAwaaWpa7W11juTdobu3N25ovcRRxp5yChDRx1t9En5zDxllqmzzjb7iist2n+VpW7V1VbfYVNKO2/ZZeuuu+1+qLWTTj5yytFTTzv9PWuvrH7OWvgpc7/PWnhlzTKW73X6I2scVn0bIhiciOWMjMUcyLhaBijoaDnzNeQcLXOWM98iTSGRrAWx5KxgGSODeYcoJ7zn7kfmfps3J/k/ylv8Veacpe7/I3POUvfK3Ne8fZO11S+jpJsg60KLqU8HYDvamKzK0Ho07Nx2TauMJEOgQyIU2NDJPjJQa7HskLWQv9yrjxPc2VvPcOcYnve019F0FlN6YtajXRRWjkpqm3FWajHXMCWH0lirnM5cXXaWVPnrSgrNs5AmRLXWkkddoZweassDBpcxeu91dwKaJokZnmWdJNri7munFoDhUVyuq45ZJMU1arsFxtZOnMvoORCe0c62dW/b4dA1DxE7BhIiJIUqTVzlRv2by/44WHMtibD7VlgaASlEPIyVfWgyT54rnY/RK343CiYsaqQxwkxBW6lrU0eTpB9jiBaVibUv+eU69Nerdf/BpnqfgESofXcKPfqxa6EdUhoteFdjZr3+7DFBTPbQZa01Sg+95rxrj77utdj+6mvSP3n7ncjFBBroS1303jwmIlJvrwWRp3My9fYqsleN9ZVRVPL7q9zfXfa6KoQ9iOfQsizie7IHympBni4alarsdEL/EBRCMho7GKmMViL7Cm2l2dqWk8pqKIhOq/vTmvEyTVtbqLRqTgHWbhPUIPVF33PuYWsJHyfowKRds+ietmTQOSVsV7OUJmPuAQZuet+fHNOKg+2c0mo+FMhYpKqgMkdvegxByHDWI332cQb3IiLiLGWs0ZV7YbzRFv2qPtnmwDu4HAAJZ29aYMjsWtc4O1OrQrHSGEcCJeCAwsFIVanVLlIplbm6HOvZs0PJp8qtIz09H4Lv729k44By7fibjnncyY1l7nB/jX2fWjSPBcRxTaHPo9RFGoZ0UBogDUJDrW7VIyDnAZtbu5VNu49nLluCMPUq1C7pPRJTDTXTG61Ip0Harf1o2ooPI+pk6+ciJJ1Kcuq9AHz7sZvXXugU2w0zrLvq1wJes9+zNn9272v7ckpfC0uYg7uObOGIN2KzkstPUXIU86cokQWIKdFE9ju101jlmcl+q2I5X7Bd4Y3eWvdcvANVqu37U3ZGKJydwy/WhA6ljY+fQJCL6KA9WUSl6k8MB1g6vu+mcxHarbOfZ02ifsHAexa4DF7LTaE7qTFAwFS2Z4iEp6GCTqaYaZxIefoD/1KOkznjhhAA0E591k7z9TOIJ8kHV3dJNqX7NGfYZd7QpQ1L3Mh1Bu2MDAylVmlYeWIXx7wlszK0GG8dzdNu8VCK7GgbNr5m+TQJDQhdlzo3LYg8MQnRUKTqmaZ211evT/BStO6G42+P06LAQwF2DCeobJxA5SJwgg3fRXxagavdehCOvulXsg5VDmBiTv1y+dd1aj6GeJrcKyyvoHCIsLxC8QrELVGEYlrhw/ifQ1KmEzQWqgmjopaFSRUkAKVifnOALwKIi3oQweuwCsRev6W6dMBOp3uLKZ/c17nz1y39JgdvO3Ift3QzXX+f5l9kuePXjKaRc5BB1wXJLVN9d3Bk8AIaLwZy2e23sLth+bM9X5cNxsVmIZ5rYSSz8O0HKJsaMVjeyJmyHhwqUP69lqhQPOiWmUV3K8FF5Ckcm1ecQKDiWqx1UBQIRD/ROR0ERwJ3y8qOFYFxa58a68ZXClPrNH2ksNFj+QuqWZHEhKOkanr0AH2ZNEGaCI2LVpNx0NWYThYZo0kTtr7VUYHUMYSxR3zO2hae82xh64cLJsouplPBGqFwwZnM31Dtg7tkBwDNTKAQgdtGwJ5lagaaMkmOYiywiq3An8VIUDX5nHVpp+4aqqMmdwYb2Qbcy9BxjXUaXA9cRIOKVO2TpRiGpUdssDkeRbAf4O9kaKD8UcHB1lLkIWgNr9TmZU+UnnwhHi5GWktP+K9/bNHboO52qH92++O9UimZbSBna7NVhHWrCPJGbgDKGI+NHuh65XDOECQaet/aIPZYtBtZSPusn8Z+vQdcAyGYauij624OsSCOvii3BBNiaBxkkCJbKEt0g68lItci5mLDSz0X3HEYeIGclBJSEMuKZ4+2nbFuTqPWvZdwS4yZIpuZakLwJHuxjKwTqz3oWWU7ayI6MGp5JOMIRDkFudaGYLHfHstCP8JFg6a1qdNMYMoq1iXwgLRB19N2gxVhxrFzB5uUEMUNhNxXuRDeP2gXC5Lpl02pVVSoPdLZ+BwKTHcRTI1nb7OSUSNRbVOe2iC/Vm7fnX6dREwCG9QA6ZXjdrFsIF12pJB1INZMuuE1JwFbUCw9EKnzmgLNgcuafWu6Urwh8xeigSTR/asi4Kp4bQ07rD5Pe/QU8Ga9Udq2LkoWNYRtwhcJ0B1tbKugCT1l5OwZ1ZGUQ0uVBPzgkDnDDdArCqgE7AWshWZtLcwUQ0Qzqin4WUZQU1yxKTCC0nQp9xWwgxhgU/Gkji7Hej1dahb/2z7Fp20W2QpI7MlRcJA88Tk6QkMY9I0jQAAkEwArz1DmPJ0F4smH+bfONB/bGnSft63dn/v679ra/bmv/66t3W/7eo7N0H3YtX41VkYqSMIAdjHY3Z4IC6VRsrinMKYpItKAuwqYrGGSyoOaafkxExJiEVR6SxNFRklSoqvxuZ7Fz0g3OrObUrgehkDcJlZhDx84uYpi6aZVZafOptqDxRBB/s1fWg6lVQfosdAxxWEgVu4JF8so5eCBujGT34QGjPfDDO8Mna3iwws3zWNcZpY+s7pSsjUUntYPC4I9UWehYvTLLrRihmAe9q1LrRbBqwQcQPpzFRiptLIxXgjBy3LbwdKDCSL0DhCwWHY0g5FkUmK+NWPrEmnQQTUDNmTfXG0fY9uW7HkNcny6Joo+rHSBwGbHbNiaN8UoGRoDmSuqNGe5Q9nTkCGl1GbDkJC4vT0uPA7zqPjLKsX8DLnYJn7B0+Z7swfChtKHZU16aK/WezM18UNLvJSE+6I7PiuJzzriTUW8aYh+3v2cewNFFjVLvGqdhYmJiYGgT1mq4K9IXUIVmJO9ksC+EIAXKrKbdQm8xkL/xPgnsazQZe42eiKYdBOujtAh/Wuwp93DO2rEvpyZqP7bscOXchs2yJH6yMFoPghwGYlqwDSx/MBdg0ZgZRRUv4I9JZp/rqVAOsV5aITKMsHnrpgWfE0x67RKzEpNgyJmr0KjtbFLq1wx2dwHw+fnengT2/yobvwo+fTUNKIseUw/cN/sWZ2JXGDp2g1caR5uIqvysHIMawcorZ7MZceeqKGGAJaWQSWGhqNXLTP7uGV4XBEmitZqgOfo90FUYA6FFIH6moCABkqnCXuie3BHgos7s+xBFQ76jRrtPce2UOVW/Gy4RlQtnEcFROxBSmiviAOmvXcH52ZVCsb8fCBKy0MOABLlcSgLHDN8FBu9uWpWhx4jLyHvQTFvvDnrItqgEPMCFaBOtgebpkvDfeq6qhoBUtCoBns41a3A3U3vddG7orHJCsCTsPo0oNkSyKBwCx6RtwTe08CmO8hLe2Q1rk4evwai7WVQhzewWoIlDN2NUeZI9jAKKvn2ivcx7fs1G/amWqw+MBB5/45ViB3k0MtjJlRfJYtiY1P0BFqpm+6259Yd2pfWYxFPaCgmxC720Ccg+RtvJy34MhwGJMqY8C1JAzR8tJtPxlnl9jb5M/UN5n3A4kPXDCqR0kMD3q2lxRap8WE1HL5f9vnu3nsjw57HTrsPd38zb37RIC4QmoNMdXvJMECOASgss4lVBYxhz48o1XmfIAZRiJJBGzptkNYLemneNHQ73BfwNHAHRckErTGbfVeG8nEbk+Ltiepe1lNwPUWO1kKwZPBApz0fp1XH9ALkwpux4Nh9pKd05NzpUbq5OwQFxgMVh2zLJtqAkwl0AKseUqGnuRHlXal6cNKfIvebSDiJUMHADHogduetCWgRYSQ9GpkFlAeFpRe2gUwsI3dBiaS9ukdPmHpGpaUI3LOeMpp1pj1AAC8Qgjj2gToEgtYm6OC4mSXAApEMwCBL+/2SCBpGKQPZAjqxrTGg950cEMMCYCMg8GNd/GVZyCpwOqICL2IPGgWUa3MoyPCl1P5uSBfyxJpiLKz2YYvxdDTyptvTBzA4AZy4OSIagXsKpeB34FcamgrCjHSkqbiRp1EcYGUT3OfY2fyvfUfCsDQvA4KRGH9sKPqXCoQBMfW67Lt143b7HtUp4WuFrLCDXH3LMAj0Vv3uVl10O3oCPIprJRTPXkArWjwav9HlaNSOasjV2fXbhA6LGQmdgL/lH8QhDadNeij9wbD48GdcscdHA7SGIBe9suJpJboo9r2k1RjRpxMnJb5A/23IVN787E/v9k1lbwFugVUrBig35zu1Dyc0QMQiCFuj3sBhqkd023N+NAq0uxAk9l0KCq8xCSBs5gap/yhd98ltFvwSm1ATSXgy1QKoddptLoRTwzJ2K3aUagXY5HaZoktTnyi2uCfqZJg1hDrN4pg3xEAQlRGMu0R8Lt6+iULstPvUrPy8W/f2YdLNhBE8EhOjVEbdKUTztiQJLeI7srKtZl+KSaqbFKGmGmqFa0t2kCp8h3goCyZubQdbay+ITVg3z4y54tYYtn3XDTYgXEGFDzUEimme7rGh9Rb9U5EdU4dazTmX07I9uKdLbhLtAWBsUriDLkAyM6NmwDMXWoSZ1h0ZFVTKRBxCfcse4GKHIB907c3EH866f7n541n3Lzd/POv+5eaPZ92/b+o56/59U/csLGIJhLZzovUD9F5NLNz/sMKJW64eQXGsEt3/Ap3b5NS9uFEHAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAA7DAAAOwwHHb6hkAAAAB3RJTUUH4ggIEzIxwFI6ZQAAIABJREFUeNrt3Xt0VNWhP/DvOfOevCaThIQQEgIhYdJAgBA0IigCFq0SK1IsQqFY9ba9vVpX+7Pt9XetP7231lbb2iJ4kYLVX0HxFp9UqxRcPyAQH6Agz5CQFxDymMkk855z9u+PQEqaiUweMxPJ97NWlmvNGSZx7zP7u/c+++wjCSEEiIiIrjAyi4CIiBhwREREXxLaofogIQSEEFBVFYqiQFXV7mOSJLGkiYioR2b0GG3Jco+fociNQQec3++H2+2G2+2Gz+cDL+kNw2G6LHd3QCi29XBpx49YDyOVJEmQJClkPUiSBL1eD5PJhLi4OOj1+gGHnTSQRSZCCHi9XrS3t8Pr9fJkYcARG1bWAw1JwIUKO4vFArPZ3O+g63fABQIBtLW1we12s8FkwBEbVtYDRSzgLmU0GmG1WmE0GiMTcJ2dnWhtbYWiKKwhBhyxYWU9UNQC7mLdWSwWJCUlhTWaC+sanBAC7e3tsNvtbCSJiCgmVFVFW1sbAoEAUlNTLxtyYQVce3s72traWLpERBRzHR0dAHDZkLvsfXCdnZ2w2+0sUSIiGlYh53A4Bj6CCwQCaG1tHXHTkk6nE1VVVWhra4NGo0FWVhays7NhMBh4VsXI559/jkAggOLiYt5XGUWdnZ04ffo0mpqaIIRAYmIiJkyYgJSUFBZOlAghYLfbUVVVBafTCZ1Oh9zcXGRmZkKr1Y7osnE4HDAajTCZTP0PuLa2thG3oKSqqgrr169HTU3NP4a5sowZM2bg29/+Nr/YMVBdXY01a9agtLQUU6ZMYcBFyfHjx7Fp0yacOnWqx+tpaWlYsWIFZs6cCVnmZkiRDreDBw/ij3/8I5qamrpf1+l0mD9/PpYsWYL4+PgRXT6tra3IzMwMeS72GXBerxdut3vEjdzWrVuHpqYm3HbbbZgyZQr8fj8++OADVFRUIDU1FStWrIBGo+E3L0onb01NDZ555hm0tLSwQKKopaUFzz77LFpbW3HLLbdg2rRpkGUZJ06cwNtvv41nnnkGjzzyCAoKClhYEdTQ0IA1a9YAAFasWIEJEybA4/Fg586d+Otf/4qEhAQsXrx4RHf6/H4/XC4XEhISwgu4i6smR9rU5KFDh1BXV4e7774bCxYs6O4RFBQUQFVV7NmzBwsXLkRGRga/eRHm8Xiwf/9+bNmyBUIIdipi8F04d+4cVq1ahRtvvLG7/AsLC5GVlYWnnnoKFRUVyM/P54g6QlRVxd69e+FyufDggw9ixowZ3WU9ceJEtLa2oqKiAgsXLhzRozigayFkfHx8r3Mx5PxCMBgccaM3VVVx5MgRxMfHY/r06T2Gu3FxcZg7dy46OjpQXV3Nb16EBYNBbNy4EWvXrsX06dPx4IMPjvgvcLQFAgHk5OSgpKSkR+dCkiQUFhYiPT0dZ8+eRTAYZGFF0PTp07Fy5UoUFhb2aLzNZjNGjRoFRVF469aF89Xr9YY3gvN4PCOu0Px+PxobGzF27NiQQ93Ro0fDaDSirq4OZWVl7LVGkBACVqsVDz/8MCZNmgSn08lCibL58+djzpw50Ov1ITsgPp8PCQkJHFlHkCzLmDhxIiZOnNirMT9+/Dg+++wz3HDDDYiLi2ObIQRcLlevxSZ9BtxI4/f7YbfbMX78+JArk8xmMwwGA+8HjAKdToelS5eyExHjxrWvLZEOHz6MtrY2TJ06lYtMosjhcGD79u2oq6vDoUOHsGDBApSXl7MOLvB6vRBC9Gg3tH019iOxB6AoCkwmU8iGVafTwWg0dl+bZOMbWSzf4am6uhpbtmxBcXExpk2bxgKJoo6ODlRWViIQCEBRFJw9exbnz59HQkICvy8XRraqqvaYVegVcP/8LDc2rL2DkGgkOnnyJJ555hmYTCasXr2aU2NRNmrUKDz66KMQQqC2thbr16/HU089hZ/+9KfIzs4e8eUjhEAwGOwRcL3GtqqqjshGXJIkyLLc5/XHi9cdwt3kk+hKoaoqDh48iKeffhqJiYm4//77MXr0aBZMlBkMBiQlJcFisaC4uBj33HMPnE4ndu3axc2jLzlXL6UNlYIjMeB0Oh0sFgva29uhKEqv63Aejwc+nw/Jyck8i2jE8Pv9+Pvf/46XXnoJkydPxurVq5GWlsaCieKoRAgR8jpbTk4OLBYLqquroSgKr8WFE3AjlV6vR2ZmJg4cOAC3291rW66mpiZ4vV5kZWVxBEcjgsvlwpYtW/D+++/jq1/9KhYvXhxyhTFFrnOxfft21NTU4L777oPZbO5xPBgMIhgMhlzpSl0Y+RdoNBrYbDbY7XYcPHiwxyjW5/Nhz5490Ol0yMnJYWHRFc/r9WLz5s3YsWMHli9fjmXLljHcot04yzIaGxvx0Ucf9douTVVVHDhwAA6HA0VFRSN+T8q+sFQuUVRUhOTkZGzcuBEej6fHVl07d+7EnDlzeO2BRoSPP/4Y7733HkpLS1FcXBzy9hiNRhPWM7logI2zVovrr78e+/btw3PPPYfly5cjJycHfr8fBw8exMsvv4yxY8fimmuuYR0w4C7ParXi3nvvxfPPP49NmzZ1vy5JEmw2G+644w5OB9AVz+/3491334UQApWVlaisrAz5vsmTJ+Ohhx7idyKCbDYb7rvvPvzpT3/C008/3aNNysvLw913343U1FQWFAPu8iRJQklJCbKysnDo0CE0NTVBlmWMHz8eRUVFXBYdIzqdDvPmzePoOUp8Ph9sNhvy8/O/8H1cURx5sizj2muvxcSJE/Hpp5+iubkZGo0GEyZMQGFhIduky7Xp4p+WTF7csor3e11ZX5KRujp2uNUDl3OzHqhrMCFJ0pDXQ3p6eo/Q5yITIiK6MjszLAIiImLAERERMeCIiIgYcERERAw4IiIiBhwRETHgiIiIGHBERETDWMitujQazZDteuE4eBCeY8cgc0uf2JEkqEIgYDCgLTsbgnURE0IIBAIBaDSaHk8dpuhSFAWKokCn03GrsZg1SRIURYHJZEJhYWF0A05RlCELOKm6Grqf/IQ1GmMaAL6yMpy45RaobFyJaBhITU1FQUFBdAOOrkzx2dn45rJl0BqNLIwYqK2txa5du1BSUoKioiIWSIzs3r0b1dXVWLhwIUaNGsUCiQG3242//OUvEf89DLiRNIozmZCeng6dycTCiIGOjg4AXbvwZ2RksEBiJC4uDpIkITU1lfUQIy6XC7Ic+SUgXGRCRERXpJiM4OTiCdBcY2PpR5B6rBHKzgMsCCJiwEWT8YZSJP+vxSz9COr8n/1oZ8AR0QjGKUoiImLAERERMeCIiIgYcERERAw4IiIiBhwRETHgiIiIGHBEREQMOCIiIgYcERERA46IiIgBR0REDDgiIiIGHBEREQOOiIiIAUdERMSAIyIiYsAREREDjoiIiAFHRETEgCMiImLAERERMeCIiIgBR0RExIAjIiJiwBERETHgiIiIGHBEREQMOCIiYsAREREx4IiIiBhwREREDDgiIqJB0ob7xmAwiPr6etTV1SEQCCAxMRETJkyA1WqFJEksSSIiGhKKouDMmTOoqamB3++H2WxGXl4e0tLS+pU3YQWcx+PBq6++iu3bt0NRlO7XU1JSsGLFCpSVlTHkiIho0AKBAN566y1s27YNXq+3+/XExEQsXboU8+bNgyyHN/kYVsDt2bMHb775Jmw2GxYuXAiLxYKqqiq89tpr2LhxI3JycjBmzBjWDBERDconn3yCzZs3Izc3F1/72teQlpaG+vp6vP7669i4cSOys7NRUFAwNAHncrnwzjvvIDs7Gw888ACSk5MBAJMmTcLo0aPx29/+FpWVlbjttts4iiMiogHz+XzYsWMHrFYr7r//fmRmZgIAbDYbxo4di1/+8pfYs2cP8vLyoNFoLvt5lx3nnTlzBmfPnsXcuXO7ww0AJEnC5MmTkZeXh4qKCvh8PtYOERENmN1uR1VVFcrKypCRkdHjWF5eHqZNm4YDBw6gs7MzrM+7bMCdP38egUAA2dnZvY4ZDAaMGzcOjY2N6OjoYO0QEdGAtbW1weVyITc3t9d1Np1Oh5ycHLS0tMDhcAxNwNntdmg0GsTHx4c8brVaEQgE4PF4WDtERDRgTqcTkiQhKSkp5HGLxQJFUeB2u4cm4BRFgVarhV6vD3ncZDIBAKcoiYhoUFRVhSRJMBqNIY8bjUZIktRjdeWgAu5yLi4sEUKwdoiIaEgypb/HBhRwsixDURQEAoGQxy9OTRoMBtYMERENmCzLUFW1zxlBr9cLIUTYeXPZgLNYLAgGg33OeTocDmi12u6pSiIiooFISEiAEKLPVZJOpxMajQZms3loAm7UqFHQarU4c+ZMr2N+vx+1tbVIT0/vcxEKERFROJKTk2E2m1FfXw9VVXscCwaDqKurg8Vi6XMRSr8DLjMzE2lpadi1axecTmf360IInDx5EidPnsS0adP6vChIREQUDqvVinHjxmHv3r1oaWnpcayhoQEHDhyAzWYLe0B12Z1MEhISMHfuXPz5z3/G2rVrsWjRIiQlJaGmpgYvvfQSJEnCrFmzwt4bbCRTIdCpeOBTg1CEAiEEZEmGRpJh1OgRJxsggbvBEH3ZKR0dUFwuqMEghBCQJAmSLEOj10NrtQJsL0MyGo2YPXs21q1bhzVr1uCOO+5AamoqGhsbsWXLFrhcLsyePRs6nW5oAg4A5s6di9OnT2Pfvn34+OOPu183m81Yvnw5cnNzWTN9CAoF5wPt+NxdhwPeGtQGW+BQvfCJABQIaCUZJkmHZMmM8bo0lJgmYJI5C8maeGgkfgmIvhy9VxVBhwMdn32Gjl274D1wAOqJE1DPnIHo7ISk10NKTYU8dix0JSWImzkTpvx8xBcXQ+bsVw9XX301Tp06hZ07d+Kxxx7rft1gMGDp0qWYPHly2J8VVsAlJSXhu9/9LubOnYsTJ07A5/PBYrGguLgYWVlZ3IMyZLCpqPKewRvtH2K/rwYK1JDvCwgFAaHACS9qlTbs9B6H3qHBfNNXcFPidGQZUjiqIxrGfI2NaP3LX9D+u99BPXUq5HuE1wvR0AC1oQHBigpc3BbD8I1vIOW730XSzJmQw1w4caUzm81YtWoVrr32Whw5cgQejwfx8fGYMmUKxo0b16/ZwrCfB2cwGFBcXIzi4mLWwBcQEGj0teH19v34wHscfqH0+zP8QsF292f4wHMMt5in4quWabBqE1i4RMOI4nSi9a230Pbb30L58MOBheMrr+DMa6+hbcUKjPr+9xE/ZQqkMDYRvtLpdDrYbDbYbLZBfQ7nwIY43Co6juNnTZvxnufIgMLtUi7hx8uuSjxy7mUc9TSwgImGCW9tLU4/8ACa77prwOH2jx6tH94NG1B/441o2rQJKneFGjIMuCHiF0Fst3+M39nfgVN4h/Sz6xUHnmh+DR92noQK7hhDFLterEDnoUOoXbkS3o0bh/ajW1rQet99aPzd76Bw83oG3HChQuCv9o+x3rkLPhHscSxFk4JfjPsFFiYsHNTvaBdePNH6Jio7TrDAiWLEfewYGlatQvCDD3ods/zmN0hdvx4Ic4VfSIoC50MPoeHJJ6GGuaEwMeAi16GDQIXzGF7q2NvrWJ4+D/865l9RllaGLGPWoH+XAhVr7H/DcU8jC54oynwNDai/914on3zS43UpIwOWJ59E2je/CfOUKcAQrIrs/M//xLmNGyGCQRY8Ay52GnyteM6xAwH0vt62cvRK3DT6JugkHep8dUPy+zqED//d9h7aFfbuiKJF9Xpx9g9/QHD37l7HDOXlyPzhD6FPT0fQ6wWGYnpRCDgefRTt+/ax8BlwsREQCv7HUdHnNTeP0rUYOCiCcCmuIfu9p4It+JvjAK/HEUVJ+969cD39dOgscrkgAgFACChDOK0ompvR9PDDCNrtrIAB0rIIBu6EpxH/z3uyz+Przq5DtbsajqADe13/mMI0SUb8R+ZPMN40DlWeavz8zC8QEIF+/e7XXZ/g2gQbRuutrAiiCFI6OtD8xBNAH09U8W3ditrERGjT0+F66y3IJdOQ8P37YCqZBjkxHiKoIHC6Fs7NW+F/8c9AIPxpx+AHH6B1+3ak33UXK4IBF8WTXqh4x3mgzxu4AaBNacOWti29Xr896VZMS5oCraRFS7B1QDdydwofdnccxZKUWawMogiP3gI7dvT9Bp8P7mefBQBoZkxH+n//Afr8vB5v0WekwzSlCC1pqfD88un+/f6XXkLK174GrcXCyugnTlEOUIO7BbvdJ/v1bxLkeNybsgp3ZiyBVhpk30IF3mv5DJ1BLyuDKEJUnw/Nb74JqGpY70/8t+9BP3FC1+irpRWdFfvhr64BhIBsNsOy/JuQc8f1629wvfsuHIcOsTIYcNHzWVMNfG3+sN9fYpyKJ7Mfw5KMr8OkGfwqKwGBunMtON7KG8CJIsXT3IzTGzaEdbVbGpUK45QiQJIgPF60/OwRtN64CE133IVAQ9fKZ+2oVGiKi/r1N7iFwOm334YIM2SJATe4Xp1Qcaj1NGRD+MVXEjcVeXHjoQoVn3cehV/1D+pvkGQJcpwGn7ZUs0KIIqT18GFovd7wLiKoKpyvvwXHtjfh2P4OfK9u63r55Cko7c6LjQfg79/1djOA5jffhOLxsEL6idfgBsDhc+FTVz00yeHvGadCRaP3DN5peR+fug/hV3mPD/rv0Jg0qHKeg08JwKDRsWKIhpj96FGYwnyvaGmD65He32vt3DnQZY4GAATPn0fw4Kf9bqSlU6fQfvIkUqZOZaUw4CIrGFTgEB6YdKaw/81W+2vYat+GdrUD+boJQzP8Nsj43H0GviADjigS2nbswGC2OZdnlsD6f/43NMkWiGAQzje3Q5w517/PAKDx+eD1+1khDLjIU4QCSdu/lY/tqnPo/xAN4A76IATvhyOKBL/Xi4Hu7S9PnYLUp56AaeoUQFXR+fcP4H5m7cA+C4AaCLBCBlBu1O+AE8Oj5C5ec2a+EUXMQJ7GqLnuWqStewam4skQgSCc77wH+7/9COJ884D+BgFw2y6O4KLVKxgeDyBVvSoUj8IKIRpGNLOuRtqvfwHDpHwIjwf2//syOh7/JdDaNuBw6wSg8sHSHMFFpdAkCUKJ/bAp0B6At84LMOOIIjN6k6R+TZBI2WNhfew/usLN60Xrs+vR8aOfDjjcAMAPoBZdtwsQAy7yPTRZhhyMfW8q0BaAUatjLRJFiDE1Ff2ZGEz48QMwl0y70FBokLTyLmRWHUZmzRFk1hzB6GMHoLvjtn79DV4APgCaIXhKwUjDKcoBMOj0GKtNxjm/C7K+d7oIRUD1qVB9KoQiIEkSJI0EySB1LU4ZglJX/SoCrQGUWnNh0HEFJVEkJF9/PZxbtsAc4pgAELgwwvID0NoKkDHvekDuahMknQ661JSe/8brhdSPoBIAzgOAwQCzwcAKYcBFXoLehElxmTjjOd4j4FS/ioA9AKVDgQiGnk6QNBJ8cT54sr0QGgFvwAehistfyRaACAoE2gPwnfPBf8YPxa2gqDgbRp2elUIUiYCbNAnnAFy6C6SKrmtizgvBdvGbHl9UCMSZEejjhmwJALy+yy4WUQB4ALQAaATQDsAwcSIy8vNZIQy4yJMgoTRtIv5W/zm0SVoIVSDQGkDAHgAus5uOUASOOI/j5u2Lu896WS9D0kuQZAmqT4WkkyAbZKh+FcInEHQFobpU+Jv9PYJTliSU5E5khRBFiLWwEIrNhuDRo9ACcF8InlAL9ju3bsOerdv6/CwNAP2FHze6rizoLxkJui/8tF3476UKli+H1mRihTDgoqNo1DjEVengcwYRsAegega4T5wAVJ8K+AB/k78rJMNUaMlEwZixrAyiCDGlpCD1rrvQ/vDDEBdGbQNd6nFxZNYKoK4fnyNptbAtWACJqyj7jcsTBshijMM3x8yC74xv4OF26bSHT0XA0b8bOb8xdQ4MWl5/I4oUSZaRW16OdqsV7Rj8LafiwgiwP58zZuVKjCksZGUw4KJ44kPC3OwpyNInD8nnBduD/TrrZ6Tm4ur8SawIogiz2mwY/cADQ/JZPvSefvzCdkaScM2990LLFZQMuGhLMSXiO3nzB/9BAlBc4d/MppM1uHvWVxFv5Jw8UcQ7sxoNJq1eDf011wz6s9z9HL1N+a//wrgZM1gJDLjYuGpMAe4aM7inaoug6HPVZSg/mHkzJufksvCJoiR+zBgU/vznkDSaQX1Ofx54k7FyJeb8y79AktlMM+BiRCtrsHTSHCxMmTLwgBMi7J1RVhfdgPKSMsi84EwUVWNvuAETN23q131s/yzcm8YTyspwy89/DrPFwoJnwMWWSavH3ZNvxPzkyF0IliTgO0U3YMV186DTcvErUbRJGg3yly5F3vr1gx7JfZGU8nIs/uMfkTJuHAudATc8WAxx+MG0RVg5dg70Uv9Ofknu2umkL3EaPX5UVo4V18/nqkmiWDaYOh0K7rwTRW+8Aa3N1u9//0VbMkhaLbLvuw9L1q1D+iQuIBsKHAoMIbPOgGW26zDJmoUXT+7EEffZsLsZkjb0Bs5lo/Kw+tobUTg2BxI4LUkU85DTapF7882wTJiAI3/4A1rXrgWU8BaJ9RVwhvx8lD36KKYvWgSd2cxCZsAN05NfkjEjYyIKrFn48NwJbKvdhxOeJqhfsBO4JEvQxGm6bvhG1w4lU63Z+MaMOZiRm8896IiGoeSCAlz961/j/LJlOLlhA5yvvw61peUL/00curbsutgaxF19Nb6yYgWm3HwzrNnZXFDCgPtySNCbcEN2MWaNKcTJtjP4qOkkPnRU4aS7CaGyTpekQ6FmNK4ak4+ZEwowPiOz60kBRDRsaQwGjC4rQ/qMGXD86Ec4t2cP7J99BsfGjVA6OnqP1CQJySkpSLvnHuTfcANypk5FXGoqC5IB9+Vk0OhQlJaDorQc3Bmcg4CiwK8GERBBKEKFVtJAJ2ugl7TQyhpunEz0JSTrdLBOmgTrpElQ/X4EHn8cqs/X/SNJEiS9Hpq4OEgaDXQmE2QuFmPAXUmMWj2MLHGiKzvs9HoY9HogIYGFEeu6YBEQEREDjoiIiAFHREQUOzG5IhQ82wLXwSqWfgT5T59hIRARAy7qje+W9+Hf8j5Ln4iIIoZTlERExIAjIiL6suBdWSNIZ20tNm/eDPAG05jweLqeBlZZWYmjR4+yQGLEbrdDVVW8/fbbMHAbvJhQFAXBYDDivyfiLZ0iy/Dl5ECSpK5nvlBMiGAQXklCa2srRAQf9UF9U9WuvUbdbjd8Ph8LJIaNKwA4nc6udoliM7rSaqGJcFskCdFzZ0S/34/GxkYIIYbmZPL7oQYC3Ac/hiRZBoSACkBluMWMLMvdIUexrQdFURhuMa6Di3S6odtzNz09HXFxcdEbwWn0emj03F8x1ieTEGLIOi3EgGM90KA63ZIESZIiXg9cZEJERFdmZ4ZFQEREDDgiIiIGHBEREQOOiIhoSPGO3xACgQAaGxvR3t4OWZaRkZGBlJSUHktbKbrq6+sRCASQm5vL5d1RFAwG0dTU1HX/pBCIj49HVlYWb5COMp/Ph4aGBnR2dkKn02HMmDFITEzkd4EB1z/nz5/HCy+8gA8//LD7NY1Gg0WLFqG8vBxms5mFFGXNzc34/e9/D5vNhnHjxvFLHSVNTU3YvHkz9u7d2+P1iRMnYvXq1Rg/fjzrIgpqa2uxYcMGHDt2rPs1s9mMZcuW4frrr4eet2Ex4MLh8XiwYcMGfPrpp5g5cyZKSkrg8/mwc+dObNu2DUajEeXl5RzJRTnc1q9fj9OnT8Nms7FAosTpdGLdunU4evQopk2bhquuugqyLOPQoUPYv38/fvWrX+Hf//3fMXbsWBZWFDp3Z8+exbx582Cz2dDZ2YmdO3diw4YNkCQJCxYsYEEx4C7vyJEjOHDgAG6//XYsXry4+w77mTNn4je/+Q127NiBOXPmICUlhYUVYaqq4tixY9i0aRPq6+s5Uoiyw4cP4/PPP0d5eTmWLFnSPUqYM2cOCgoK8Pzzz2P37t248847WTcRIoRARUUF6uvr8Z3vfAfz5s3r7lyXlpbisccew44dOzBr1izOLPWBQ5FLTqbDhw/DaDRizpw5PbaPsVqtuOmmm9DS0oKamhoWVoQpioKtW7fiiSeeQEJCAn74wx8iISGBBRNFTU1NsFqtvabAZFnG1VdfjbS0NNTV1UVlw9yR3Calp6djwYIFKC0t7TFzlJycjPHjx8PtdrMOOIK7PL/fj/r6emRlZSE5ObnX8ezsbOj1etTW1qKkpIS91giP3s6fP49vfetbKCsrg9frZXlH2a233orZs2fDYrH07hXLMiRJgl6v53R9JEcfsoyrrroKV111VcgOyPHjx1FYWMjRGwMuvIBra2tDVlYWtCEeJxMfHw+j0Yjm5mYWVqRPSq0W99xzDwwGAyRJgtfrZaHEoA5SU1NDHquurkZzczMWLVoU8d3g6R9cLhcOHjyIuro67N69G9nZ2ViyZEnI9ooYcL1GDX6/H2azOWSvVKfTwWg0wul0QgjBEUUESZIEo9HIghiGmpubsWXLFowZMwalpaUskCiy2+1Yu3Yt/H4/ZFnG9OnT2cFgwPWPTqcLGV4Xd7/mfDeNVE1NTVi7di3sdjseeOCBkFP5FDmJiYl4/PHHIYTAsWPH8Morr+DUqVN48MEH+xxtM+D6aMhH2qNVLv5/ezweqKraaxSnKAr8fj/i4uI4eqMRp66uDs899xxaWlpw//33o6CggIUSg4BLTEwEAIwbNw7x8fFYs2YNdu3ahdtvv53XQy+045cNuBGZ9FotEhMT0dHREfIZRV6vFz6fD1arld80GjEURcGhQ4fw7LPPIikpCT/+8Y8xYcIEFswwaMi/8pWvIDk5GUePHoWiKAy4cAJOluUR+UBAvV6P9PR0nDx5El6vt9fuAK2trfB6vcjMzOQIjkaEQCCAd999F6+vHI2OAAADUElEQVS88goKCwuxatUqZGRksGCiWP6VlZU4e/Ysbr311j63R+ODjHsOVHrkWaiAG4mrcrRaLQoKCnD+/HlUVVX16sV+8sknALpuFyC60gWDQbz99tt48cUXcd111+EHP/gBwy0GKioq8MYbb6CxsbFXqFVVVcHhcCA/P5+LTdC1peI/l0PIMe1IXcE2efJkGI1GbNy4ER999BE6Oztht9vx7rvvYvv27Zg8eTKysrL4raMr3pEjR/Dqq6+itLQUX//616HRaOD1env8+Hw+jh4iSKfTYfbs2QgGg3jxxRdRVVUFt9sNp9OJ/fv3Y9OmTbBYLJg1axanJwEYDIZe5RByqGY2m+FwOEZcAWVkZGDZsmV44YUX8OSTT/Y4lpycjCVLlsBkMvGbR1f86G379u3w+/2orKxEZWVlnx3Chx56iJv9RlBJSQkWL16MrVu34mc/+1mPYwkJCfje977HTvcFcXFxvV4LGXB6vR56vR5+v39EFZAsy5g/fz6ys7Oxf/9+NDQ0QJZl2Gw2lJWVIT09nWdRjOolLy8v5K4aNPRcLhckSUJRUdFlO4S8Hh1ZWq0W5eXlsNls2LdvHxobG6HT6VBYWIjS0lLWwQUajSbk4EMSfcwxtLe3o7W1lWfYFRIQQghOJw2Dehhpi7dYDxTKxduyhqoeEhMTQ94L2OfEbUJCQo8Nh4mIiIZjh+Xi/YFhB5wsy7zni4iIhrWkpKQ+rwN/4dIbs9nMx5QQEdGwZDKZvvDa/BcGnCRJSElJ4ca3REQ0rFx84sUXLbK57M0Tsixj1KhRXApMRETDJtzS09Mvu05EDvfDRo8ezQfrERFRTOn1emRkZPS5ddml+rxNIBQhBOx2O9rb27nk/EuEtwkMn3rg8nTWAw3sNgFJkhAfH4+UlJSwd27pV8Bd5PP54HA44Ha72Wgy4IgNK+uBIhZwkiTBYDDAYrHAZDL168b2AQXcpUHX2dkJt9uNQCDAWmPAERtW1gMNScBptVqYTCbEx8cPeIvEQQXcRaqqQlEU+Hw++P1+KIrS/YdzG5nhcTIx3FgPxHoYbi6tB1mWodFooNPpoNfrodPpBr2J9JAEHBER0bAbrbMIiIiIAUdERMSAIyIiYsARERENqf8Pj68i3Pq5CdsAAAAASUVORK5CYII=)
</center>

¿Qué vas a ver cuando actives la vestimenta? Tratá de pensarlo antes de hacerlo, para ver si estás
entendiendo cómo es la representación.

Completá los procedimientos que están comenzandos para que el programa de esta actividad funcione igual que el 
de la actividad anterior. ¡No te olvides de activar la vestimenta!

> **Procedimientos y procedimientos**
>
> Fijate que en la actividad anterior los procedimientos eran _primitivos_ porque ya venían hechos
> con la actividad, pero ahora vos tenés que hacerlos, con los mismos nombres.
> La diferencia entre un procedimiento primitivo y uno que construís para resolver la actividad es
> solamente quién lo escribe.

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/2.Procedimientos/2.1.Armamos%20'El%20alien%20toca%20bot%C3%B3n'/assets/resources/description.pdf "Enunciado de 'Armamos 'El alien toca botón'' en PDF"
